/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.conndata.DialConfigInfo;
import com.ibm.hwmca.base.rsf.conndata.RetainIspAccountInfo;
import com.ibm.hwmca.base.rsf.conndata.RetainTcpConnectionInfo;
import com.ibm.hwmca.base.rsf.conndata.ShadowedFile;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.util.GregorianCalendar;

public class RetainConnectionDataManager {
    private static final String TRACE_MASKT = "XCDIRPDT";
    private static final String TRACE_MASKF = "XCDIRPDF";
    private static final String TRACE_MASKD = "XCDIRPDD";
    private static final int REFRESH_INTERVAL = 7;
    private static final String RETAIN_TCPINFO_NAME = "ACTZCRY.DAT";
    private static final String RETAIN_PHONE_NAME = "ACTZPHO.DAT";
    private static final String RETAIN_ACCOUNT_NAME = "ACTZPGRP.DAT";
    private static final String TCPINFO_DATA_NAME = "actzcry.trm";
    private static final String PHONE_DATA_NAME = "actzpho.trm";
    private static final String ACCOUNT_DATA_NAME = "actzpgrp.trm";
    private static final String TCPINFO_STAGING_NAME = "actzcry.dat";
    private static final String PHONE_STAGING_NAME = "actzpho.dat";
    private static final String ACCOUNT_STAGING_NAME = "actzpgrp.dat";
    private static final int RETAIN_TCPINFO_LRECL = 120;
    private static final int RETAIN_PHONE_LRECL = 72;
    private static final int RETAIN_ACCOUNT_LRECL = 72;
    private static ShadowedFile tcpInfoFile;
    private static ShadowedFile phoneInfoFile;
    private static ShadowedFile accountInfoFile;
    private static GregorianCalendar refreshNeeded;
    private static Integer refreshState;
    private static final Integer REFRESH_DONE;
    private static final Integer REFRESH_IN_PROGRESS;
    private static Object fileUpdateGate;

    private RetainConnectionDataManager() {
        Trace.trace(TRACE_MASKT, "<> RetainConnectionDataManager()");
    }

    public static void update() {
        Trace.trace(TRACE_MASKT, "-> RetainConnectionDataManager.update()");
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar now = new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale());
        Trace.trace(TRACE_MASKD, "   RetainConnectionDataManager.update() Now: " + now.getTime());
        if (refreshNeeded == null || now.after(refreshNeeded)) {
            RetainConnectionDataManager.refresh();
        }
        Trace.trace(TRACE_MASKT, "<- RetainConnectionDataManager.update() - Next Refresh: " + refreshNeeded.getTime());
    }

    public static void forceUpdate() {
        Trace.trace(TRACE_MASKT, "-> RetainConnectionDataManager.forceUpdate()");
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar now = new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale());
        Trace.trace(TRACE_MASKD, "   RetainConnectionDataManager.forceUpdate() Now: " + now.getTime());
        RetainConnectionDataManager.refresh();
        Trace.trace(TRACE_MASKT, "<- RetainConnectionDataManager.forceUpdate() - Next Refresh: " + refreshNeeded.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresh() {
        Trace.trace(TRACE_MASKT, "-> RetainConnectionDataManager.refresh()");
        Integer n = refreshState;
        synchronized (n) {
            if (refreshState.equals(REFRESH_IN_PROGRESS)) {
                return;
            }
            refreshState = REFRESH_IN_PROGRESS;
        }
        Trace.trace(TRACE_MASKD, "   RetainConnectionDataManager.refresh() - Starting refresh");
        ShadowedFile[] files = new ShadowedFile[]{phoneInfoFile, accountInfoFile, tcpInfoFile};
        Trace.trace(TRACE_MASKD, "   RetainConnectionDataManager.refresh() - Completing refresh");
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar refreshNeeded = new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale());
        try {
            refreshNeeded.add(5, 7);
        }
        catch (IllegalArgumentException eIAE) {
            Trace.trace(TRACE_MASKF, "   RetainConnectionDataManager.refresh() - refreshNeeded.add() error");
        }
        Integer n2 = refreshState;
        synchronized (n2) {
            refreshState = REFRESH_DONE;
        }
        Trace.trace(TRACE_MASKT, "<- RetainConnectionDataManager.refresh() Refresh: " + refreshNeeded.getTime());
    }

    static void fileChanged(ShadowedFile file) {
        Trace.trace(TRACE_MASKT, "-> RetainConnectionDataManager.refreshed()");
        Trace.trace(TRACE_MASKD, "   RetainConnectionDataManager.refreshed() - File: " + file.getRetainFileName());
        if (file == phoneInfoFile) {
            DialConfigInfo.validatePhoneNumbers();
        }
        if (file == tcpInfoFile) {
            RetainTcpConnectionInfo.dumpCache();
        }
        if (file == accountInfoFile) {
            RetainIspAccountInfo.dumpCache();
        }
        Trace.trace(TRACE_MASKT, "<- RetainConnectionDataManager.refreshed()");
    }

    static String[] getTcpData() throws HException {
        Trace.trace(TRACE_MASKT, "<> RetainConnectionDataManager.getTcpData()");
        return tcpInfoFile.getData();
    }

    static String[] getPhoneData() throws HException {
        Trace.trace(TRACE_MASKT, "<> RetainConnectionDataManager.getPhoneData()");
        return phoneInfoFile.getData();
    }

    static String[] getAccountData() throws HException {
        Trace.trace(TRACE_MASKT, "<> RetainConnectionDataManager.getAccountData()");
        return accountInfoFile.getData();
    }

    static {
        REFRESH_DONE = new Integer(1);
        REFRESH_IN_PROGRESS = new Integer(2);
        fileUpdateGate = new Object();
        Trace.trace(TRACE_MASKT, "-> RetainConnectionDataManagerClass()");
        refreshState = REFRESH_DONE;
        tcpInfoFile = new ShadowedFile(TCPINFO_DATA_NAME, TCPINFO_STAGING_NAME, RETAIN_TCPINFO_NAME, 120);
        phoneInfoFile = new ShadowedFile(PHONE_DATA_NAME, PHONE_STAGING_NAME, RETAIN_PHONE_NAME, 72);
        accountInfoFile = new ShadowedFile(ACCOUNT_DATA_NAME, ACCOUNT_STAGING_NAME, RETAIN_ACCOUNT_NAME, 72);
        Trace.trace(TRACE_MASKT, "<- RetainConnectionDataManagerClass()");
    }
}

